<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 24/10/2016
 * Time: 16:44
 */

namespace Bloom\Framework;

class Uri
{
    protected $uri;
    protected $fragments;
    protected $parameter;
    static protected $instance;

    /**
     * Uri constructor.
     * @param string $uri
     * @param array  $fragments
     * @param array  $parameter
     */
    protected function __construct($uri = '', array $fragments = [], array $parameter = [])
    {
        $this->uri = $uri;
        $this->fragments = $fragments;
        $this->parameter = $parameter;
    }

    public static function createFromEnvironment(array $environment)
    {
        $home = dirname($environment['SCRIPT_FILENAME']);
        $home_dir = str_replace($environment['CONTEXT_DOCUMENT_ROOT'], '', $home);
        $uri = '';
        if(array_key_exists('REDIRECT_URL', $environment)) {
            $uri = str_replace($home_dir, '', $environment['REDIRECT_URL']);
        }
        $environment['doc_root'] = $home;
        $environment['baseDir'] = $home_dir;
        if (array_key_exists('view', $_REQUEST) && $uri !== $_REQUEST['view']) {
            $uri = '/' . $_REQUEST['view'];
        }
        $fragments = explode('/', $uri);
        unset($fragments[0]);
        return static::$instance = new static($uri, array_values($fragments), $environment);
    }

    public static function create()
    {
        return static::getInstance();
    }

    public static function getInstance()
    {
        if (static::$instance === null) {
            return static::createFromEnvironment($_SERVER);
        }
        return static::$instance;
    }

    public function getFragments($index = null)
    {
        if ($index === null) {
            return $this->fragments;
        }
        return $this->fragments[$index];
    }

    public function getUri()
    {
        return $this->uri;
    }

    public function get($parameter)
    {
        if(array_key_exists($parameter, $this->parameter)) {
            return $this->parameter[$parameter];
        }
        return null;
    }

    public function match($uri)
    {
        return preg_match('~^' . $uri . '~', $this->uri);
    }

    public function getGroup($uri)
    {
        if (preg_match('~^' . $uri . '(/.+)~', $this->uri, $matches)) {
            return $matches[1];
        }
        return '';
    }

    public function isPost()
    {
        return $this->parameter['REQUEST_METHOD'] === 'POST';
    }

    public function isGet()
    {
        return $this->parameter['REQUEST_METHOD'] === 'GET';
    }

    public function isPut()
    {
        return $this->parameter['REQUEST_METHOD'] === 'PUT';
    }

    public function isDelete()
    {
        return $this->parameter['REQUEST_METHOD'] === 'DELETE';
    }

    public function getHomeDir()
    {
        return $this->parameter['doc_root'];
    }

    public function getRelatifPath() {
        return $this->parameter['baseDir'];
    }
}
