<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 11/05/2016
 * Time: 16:03
 */

namespace Bloom\Framework\Controllers;

use Bloom\Controller\Controller;
use Bloom\Framework\Application;
use Bloom\Framework\Users\User;
use Bloom\Framework\Users\UserRights;

/**
 * Class BControllers
 * @package Bloom\Framework\Controllers
 */
abstract class BControllers extends Controller
{
    /**
     * @var Application
     */
    protected $parent;
    /**
     * @var string
     */
    protected $scope;
    /**
     * @var UserRights
     */
    protected $min_rights;
    protected $tpl;
    public $url;
    /**
     * @var array
     */
    protected $datas = [];

    public function setTpl($tpl)
    {
        $this->tpl = $tpl;
    }

    public function display(array $datas = [])
    {
        foreach($_SESSION[APP_NAME][APP_ENV] as $key=>$value) {
            $datas[$key]=$value;
        }
        $datas = array_merge($datas, $this->datas);
        $datas = array_merge($datas, ['modules'=>Application::$modules]);
        $datas = array_merge($datas, ['user'=>Application::getSession('current_user')]);
        $datas = array_merge($datas, ['errors'=>$_SESSION[APP_NAME][APP_ENV]['error']]);
        return $this->parent->render($this->scope.'/'.$this->request->get('section', 'default').($this->tpl?'_'.$this->tpl:'').'.twig', $datas);
    }

    public function __construct(Application $parent)
    {
        parent::__construct();
        $this->parent = $parent;
        $this->min_rights = new UserRights(UserRights::User);
    }

    public function getUrl()
    {
        $reflexion = new \ReflectionClass($this);
        return $this->url?:strtolower(preg_replace('/(Controllers)|(Modules)/','',$reflexion->getShortName()));
    }

    public function haveAccess(User $user = null)
    {
        if ($user === null) return false;
        return $user->right->getValue() <= $this->min_rights->getValue();
    }

    public function index()
    {
        return $this->display();
    }
}
