<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 25/05/2016
 * Time: 15:58
 */

namespace Bloom\Framework\Users;

use Bloom\Database\Database;
use Bloom\Framework\Application;

/**
 * Class User
 * @package Bloom\Framework\Users
 */
class User
{
    /**
     * @var string
     */
    public $username;
    /**
     * Md5 password
     * @var string
     */
    public $password;
    /**
     * @var string
     */
    public $email;
    /**
     * @var string
     */
    public $lastConnexion;
    /**
     * @var UserRights
     */
    public $right;
    /**
     * @var \DateTime
     */
    public $inscription_date;
    /**
     * @var int
     */
    public $id;
    public static function login($email, $password)
    {
        /**
         * @var Database $db
         */
        $db = Application::getInstance()->db;
        /**
         * @var static $user
         */
        $user = $db->select()->from('users')->where('email', '=', $email)->execute()->fetchObject(static::class);
        if($user === false ){
            return null;
        }
        $hahs = md5($password.'|'.$user->inscription_date);
        if($hahs === $user->password) {
            $db->update(['lastConnexion'=>date('Y-m-d H:i:s')])->table('users')->where('id', '=', $user->id)->execute();
            $user->right = new UserRights((int) $user->right);
            return $user;
        }
        return null;
    }

    public function check()
    {
        if(!preg_match('/^([\w_\.-]+)\@([\w\.-]+)\.([a-z\.]{2,6})$/',$this->email)) {
            throw new \InvalidArgumentException('Email should be in a valid format');
        }
        if ($this->username === null || $this->username === '') {
            throw new \InvalidArgumentException('Username shouldn\'t be empty');
        }
        if(!($this->right instanceof UserRights) && !UserRights::isValid((int)$this->right)) {
            throw new \InvalidArgumentException('Rights unknown');
        }
    }

    public function save()
    {
        $this->check();
        if ($this->id !== null && $this->id !== '') {
            return $this->update();
        } else {
            return $this->insert();
        }
    }

    protected function insert()
    {
        $db = Application::getInstance()->db;
        $this->id =  $db->insert(
            [
                'username'=>$this->username,
                'password'=>$this->password,
                'email'=>$this->email,
                'inscription_date'=>$this->inscription_date,
                'lastConnexion'=>$this->lastConnexion?:'0000-00-00 00:00:00',
                '`right`'=>$this->right instanceof UserRights ? $this->right->getValue() : $this->right
            ]
        )->into('users')->execute();
        return true;
    }

    protected function update()
    {
        $db = Application::getInstance()->db;
         $db->update(
            [
                'username'=>$this->username,
                'password'=>$this->password,
                'email'=>$this->email,
                '`right`'=>$this->right instanceof UserRights ? $this->right->getValue() : $this->right
            ]
        )->table('users')->where('id', '=', $this->id)->execute();
        return true;
    }
}
