<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 07/06/2016
 * Time: 17:28
 */

namespace Bloom\Framework\Controllers;

use Assetic\Factory\AssetFactory;
use Bloom\Framework\Application;
use Bloom\Framework\Modules;
use Bloom\Framework\Users\UserRights;
use Symfony\Component\Console\Command\Command;

abstract class BModules extends BControllers implements Modules
{
    public $name;
    public $image;
    public $type;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * @param array       $row
     * @param Application $application
     * @return BModules
     */
    public static function load($row, Application $application)
    {
        $module_class = $row['class_name'];
        $new_module = new $module_class($application);
        $new_module->scope = $row['scope'];
        $new_module->image = $row['image'];
        $new_module->min_rights = new UserRights((int)$row['min_rights']);
        $new_module->url = $row['url'];
        $new_module->name = $row['name'];
        return $new_module;
    }

    public function edit()
    {
        $this->datas['nav_blocked'] = true;
        return $this->display();
    }

    public function execute()
    {
        if ($this->request->get('tpl') === null) {
            if ($this->tpl === '') {
                return $this->index();
            }
            return $this->{$this->tpl}();
        } else {
            return $this->{$this->request->get('tpl')}();
        }
    }

    /**
     * @return string|string[]
     */
    public function getViewPath()
    {
        return '';
    }

    /**
     * @return Command[]
     */
    public function getCommands()
    {
        return [];
    }

    public function getFactory()
    {
        return null;
    }

    public function __sleep()
    {
        $reflex = new \ReflectionClass(static::class);
        $toKeep = [];
        foreach ($reflex->getProperties() as $property) {
            if(!($this->{$property->getName()} instanceof Application) && !($this->{$property->getName()} instanceof \Closure)) {
                $toKeep[] = $property->getName();
            }
        }
        return $toKeep;
    }
}
