<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 24/10/2016
 * Time: 16:44
 */

namespace Bloom\Framework;

class Uri
{
    protected $uri;
    protected $fragments;
    protected $parameter;
    static protected $instance;

    /**
     * Uri constructor.
     * @param string $uri
     * @param array  $fragments
     * @param array  $parameter
     */
    protected function __construct($uri = '',array $fragments = [], array $parameter = [])
    {
        $this->uri = $uri;
        $this->fragments = $fragments;
        $this->parameter = $parameter;
    }

    public static function createFromEnvironment(array $environment)
    {
        $home = dirname($environment['SCRIPT_FILENAME']);
        $home_dir = str_replace($environment['CONTEXT_DOCUMENT_ROOT'], '', $home);
        $uri = str_replace($home_dir, '', $environment['REDIRECT_URL']);
        if($uri !== $_REQUEST['view']) {
            $uri = '/'.$_REQUEST['view'];
        }
        $fragments = explode('/',$uri);
        unset($fragments[0]);
        return static::$instance = new static($uri, array_values($fragments), $environment);
    }

    public static function create() {
        return static::getInstance();
    }

    public static function getInstance() {
        if(static::$instance === null ) {
            return static::createFromEnvironment($_SERVER);
        }
        return static::$instance;
    }

    public function getFragments($index = null)
    {
        if($index === null) {
            return $this->fragments;
        }
        return $this->fragments[$index];
    }

    public function getUri()
    {
        return $this->uri;
    }

    public function match($uri)
    {
        return preg_match('~^'.$uri.'~', $this->uri);
    }

    public function getGroup($uri) {
        preg_match('~^'.$uri.'/(.+)~', $this->uri, $matches);
        return $matches[1];
    }
}
