<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 07/06/2016
 * Time: 12:53
 */

namespace Bloom\Framework;


use Assetic\Factory\AssetFactory;
use Bloom\Framework\Users\User;
use Symfony\Component\Console\Command\Command;

interface Modules
{
    /**
     * @return string
     */
    public function getUrl();

    /**
     * @return string
     */
    public function getName();

    /**
     * @return string
     */
    public function getImage();

    /**
     * @param string $tpl
     */
    public function setTpl($tpl);
    /**
     * @param array  $data
     * @return string
     */
    public function display(array $data);

    /**
     * @param User $user
     * @return boolean
     */
    public function haveAccess(User $user);
    /**
     * @return string|string[]
     */
    public function getViewPath();

    /**
     * @return Command[]
     */
    public function getCommands();

    /**
     * @return AssetFactory|null
     */
    public function getFactory();

    public function makeUrl($item);
}
