<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 19/04/2021
 * Time: 16:05
 */

namespace Bloom\CMS\Core\Framework;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Page;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Suivis
 * @package Bloom\CMS\Core\Framework
 * @property Page   $page
 * @property int    $id
 * @property int    $statut_avt
 * @property int    $statut_apr
 * @property bool   $notified
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class Suivis extends Model
{
    public function item()
    {
        return $this->morphTo();
    }

    public function scopePublication(Builder $query)
    {
        return $query->where('statut_apr', '=', Statut::PUBLIE);
    }

    public function scopeDepublication(Builder $query)
    {
        return $query->where('statut_apr', '=', Statut::ARCHIVE);
    }
}
