<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 22/03/2021
 * Time: 15:58
 */

namespace Bloom\CMS\Core\Http\Controllers;

use Bloom\CMS\Core\Helpers\Workflow;
use Illuminate\View\View;

/**
 * Class AdminController
 * @package Bloom\CMS\Core\Http\Controllers
 *
 *
 */
class AdminController
{
    /**
     * @param ?Workflow $workflow
     *
     * @return View
     */
    public function listing(Workflow $workflow = null)
    {
        $request = request();
        if ($workflow === null) {
            // Cas d'index par défaut sans précision de workflow
            // On va chargé le premier
            $workflow = Workflow::isModule($request->module_actif)
                ->orderBy('ordre')
                ->first();
        }
        // On charge tous les workflow
        $all = Workflow::query()
            ->where('on', '=', $workflow->on)
            ->orderBy('ordre')
            ->get();

        $order = [
            'order' => request('order'),
            'item'  => request('orderBy')
        ];

        $contents = $workflow->contents;

        // On ordonne les donneés en fonction de l'ordre demandé
        if ($order['item']) {
            if (strtoupper($order['order']) === 'ASC') {
                $contents = $contents->sortBy($order['item']);
            } else {
                $contents = $contents->sortByDesc($order['item']);
            }
        }

        return view(
            'Core::admin.listing',
            [
                'contents' => $contents,
                'workflow' => $workflow,
                'all'      => $all,
                'contenu'  => class_basename($workflow->on),
                'order'    => $order,
                'sub_actions' => $workflow->sub_actions->toArray()['actions'],
                'actions' => $workflow->actions->toArray()['actions'],
            ]
        );
    }
}
