<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 01/12/2020
 * Time: 12:33
 */

namespace Bloom\CMS\Core\Contenus;

use Illuminate\Database\Eloquent\Builder;

/**
 * Trait HasStatut
 * @package Bloom\CMS\Core\Contenus
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 */
trait HasStatut
{

    public function statut()
    {
        return $this->belongsTo(Statut::class);
    }

    public function getIsPublishedAttribute(): bool
    {
        return $this->statut_id == Statut::PUBLIE;
    }

    public function scopePublished(Builder $query)
    {
        return $query->where('statut_id', '=', Statut::PUBLIE);
    }

    public function scopeArchived(Builder $query)
    {
        return $query->where('statut_id', '=', Statut::ARCHIVE);
    }
}
