<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 14/09/2020
 * Time: 11:35
 */

namespace Bloom\CMS\Core\Http\Redirect;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Campagne
 *
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property string                   nom
 * @property Redirection[]|Collection redirections
 */
class Campagne extends Model
{
    public const SYSTEM = 1;

    public function redirections()
    {
        return $this->belongsToMany(Redirection::class, 'campagne_redirections');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Builder[]|Collection|Campagne|null
     */
    public static function system()
    {
        return self::query()->find(self::SYSTEM);
    }
}
