<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 29/03/2021
 * Time: 11:49
 */

namespace Bloom\CMS\Core\Helpers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;

/**
 * Class TableHeader
 * @package Bloom\CMS\Core\Helpers
 */
class TableHeader
{
    public $titre;
    public $can_order = false;
    public $is_image = false;
    public $is_date = false;
    public $title_date = false;
    public $accessor;
    /**
     * @var string|false
     */
    public $title = false;

    public function __construct(string $titre, string $accessor)
    {
        $this->titre = $titre;
        $this->accessor = $accessor;
    }

    public function value(Model $model, string $accessor = null)
    {
        $accessor = $accessor ?? $this->accessor;

        return Arr::get($model, $accessor);
    }

    /**
     * @return $this
     */
    public function isImage(): TableHeader
    {
        $this->is_image = true;

        return $this;
    }

    /**
     * @return $this
     */
    public function canOrder(): TableHeader
    {
        $this->can_order = true;

        return $this;
    }

    /**
     * @return $this
     */
    public function isDate(): TableHeader
    {
        $this->is_date = true;

        return $this;
    }

    /**
     * @return $this
     */
    public function titleIsDate(): TableHeader
    {
        $this->title_date = true;

        return $this;
    }

    /**
     * @param string $accessor
     * @return $this
     */
    public function haveTitle(string $accessor): TableHeader
    {
        $this->title = $accessor;

        return $this;
    }
}
