<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 11:07
 */

namespace Bloom\CMS\Core\Framework\Commands;

use Bloom\CMS\Core\Contenus\Statut;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Collection;

/**
 * Class DepublicationsCommand
 * @package Bloom\CMS\Core\Framework\Commands
 */
class DepublicationsCommand extends Command
{
    protected $signature = "page:unpublish 
    {--D|dry-run : Fait le tour des pages mais ne les depublies pas vraiment, outils pour débug}
    {--N|now= : Surcharge la date de comparaison, par défaut prends la date du jour (format Y-m-d)}
    ";
    protected $description = "Depublie toutes les pages et meas qui ont un to_unpublish_at = [now]";

    public function handle()
    {
        $result = $this->call(
            ChangeStatutCommand::class,
            [
                '--dry-run' => $this->option('dry-run') ?: false,
                '--now'     => $this->option('now'),
                'statut'    => Statut::ARCHIVE,
                'colonne'   => 'to_unpublish_at'
            ]
        );
        // On verifie qu'il n'y ai au moins 1 mea principal
        $meaClass = '\Bloom\CMS\Modules\Meas\Model\Mea';
        if (class_exists($meaClass)) {
            /**
             * @var Collection $meas
             */
            if ($meaClass::query()->where('type', '=', 'MAIN')->where('statut_id', '=', Statut::PUBLIE)->exists()) {
                $meaDefault = $meaClass::find(0);
                $meaDefault->statut_id = Statut::PUBLIE;
                $meaDefault->to_publish_at = now();
                $meaDefault->save();
            }
        }

        return $result;
    }
}
