<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 11:47
 */

namespace Bloom\CMS\Core\Framework\Commands;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Framework\Suivis;
use Bloom\CMS\Core\Http\Page;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Symfony\Component\Console\Output\Output;

class ChangeStatutCommand extends Command
{
    protected $signature = "page:statut 
    {statut : Le nouveau statut a appliquer} 
    {colonne : le nom de la colonne a verifier}
    {--D|dry-run : Fait le tour des pages mais ne les depublies pas vraiment, outils pour débug}
    {--N|now= : Surcharge la date de comparaison, par défaut prends la date du jour (format Y-m-d)}
    ";
    protected $description = "Applique le [statut] toutes les pages et meas qui ont un [colonne] = [now]";

    public function handle()
    {
        $now = $this->getDate();
        $meaClass = '\Bloom\CMS\Modules\Meas\Model\Mea';
        $doMea = true;
        if (!class_exists($meaClass)) {
            $doMea = false;
            $this->warn('Mea model introuvable, seul les pages seront traitées');
        }
        $this->work(
            Page::query()->where($this->argument('colonne'), '<=', $now)->whereNotIn(
                'statut_id',
                [$this->argument('statut'), Statut::SUPPRIMER]
            )
        );
        if ($doMea) {
            $this->work(
                $meaClass::query()->where($this->argument('colonne'), '<=', $now)->whereNotIn(
                    'statut_id',
                    [$this->argument('statut'), Statut::SUPPRIMER]
                )->where('id', '!=', 0)
            );
        }
    }

    protected function work(Builder $query)
    {
        if ($this->verbosity === Output::VERBOSITY_DEBUG) {
            $this->comment('Run : ' . $query->toSql());
        }
        $toPublish = $query->get();

        $this->info($toPublish->count() . ' ' . $query->getModel()->getTable() . ' à traitées');

        if ($this->option('dry-run')) {
            return;
        }

        $this->change($toPublish);
    }

    protected function getDate(): Carbon
    {
        $now = $this->option('now');
        if ($now) {
            $now = Carbon::createFromFormat('Y-m-d', $now);
        } else {
            $now = now();
        }

        return $now;
    }

    protected function change(Collection $collection)
    {
        foreach ($collection as $model) {
            /**
             * @var Model $model
             */
            $suivi = new Suivis();
            $suivi->statut_avt = $model->statut_id;
            $suivi->item()->associate($model);
            $model->statut_id = $this->argument('statut');
            $suivi->statut_apr = $model->statut_id;
            $model->save();
            if ($this->verbosity === Output::VERBOSITY_DEBUG) {
                $this->comment('info suivit : ' . $suivi->toJson());
            }
            $suivi->save();
        }
    }
}
