<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 06/08/2020
 * Time: 11:09
 */

namespace Bloom\CMS\Core\Contenus;

use Bloom\CMS\Core\Framework\Module;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Applicabilite
 *
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property string titre
 * @property string contenu_type
 * @property string multiplicite
 * @property int    b_on
 * @property string route
 *
 * @property Module module
 * @property array  list Array<string, boolean>
 *
 * @method static Builder|static applicableOn(int $applicable)
 */
class Applicabilite extends Model
{
    public const ARCHI = 1;
    public const PAGE_STD = 2;
    public const PAGE_CMP = 4;
    public const STICKY = 8;
    public const NAMED_LIST = [
        'archi'    => self::ARCHI,
        'page_std' => self::PAGE_STD,
        'page_cmp' => self::PAGE_CMP,
        'sticky'   => self::STICKY
    ];
    public $timestamps = false;

    public function module()
    {
        return $this->belongsTo(Module::class);
    }

    public function getListAttribute(): array
    {
        $list = [];
        foreach (self::NAMED_LIST as $name => $bit) {
            $list[ $name ] = ((int)$this->b_on & $bit) === $bit;
        }

        return $list;
    }

    public function scopeApplicableOn(Builder $query, int $applicable)
    {
        return $query->whereRaw('b_on & ' . $applicable . ' = ' . $applicable);
    }

    public function getValueAttribute()
    {
        return $this->contenu_type . ';' . $this->multiplicite;
    }

    public function can(int $on)
    {
        return ((int)$this->b_on & $on) === $on;
    }
}
