<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddWorkflows extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('workflows', function (Blueprint $table) {
            $table->id();
            $table->string('titre');
            $table->string('code');
            $table->string('route_edit');
            $table->string('creation_titre');
            $table->text('requetes');
            $table->text('s_actions')->nullable();
            $table->text('s_sub_actions')->nullable();
            $table->text('s_headers');
            $table->string('on');
            $table->bigInteger('module_id')->unsigned();
            $table->integer('ordre');
            $table->timestamps();
            $table->foreign(['module_id'])->on('modules')->references('id');
        });
        Schema::create('workflow_transitions', function (Blueprint $table) {
            $table->unsignedBigInteger('from')->nullable();
            $table->unsignedBigInteger('to')->nullable();
            $table->boolean('statut');
            $table->string('call');
            $table->timestamps();
            $table->foreign(['from'])->on('workflows')->references('id');
            $table->foreign(['to'])->on('workflows')->references('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('workflow_transitions', function (Blueprint $table) {
            $table->dropForeign(['from']);
            $table->dropForeign(['to']);
        });
        Schema::dropIfExists('workflow_transitions');

        Schema::table('workflows', function (Blueprint $table) {
            $table->dropForeign(['module_id']);
        });
        Schema::dropIfExists('workflows');
    }
}
