<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EventSeeder extends Seeder
{
    public function run()
    {
        DB::table('events')->truncate();
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 1, 'nom' => 'Bloom\CMS\Core\Http\Events\PageArchived', 'code' => 1, 'label' => 'archived', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            ['id' => 2, 'nom' => 'Bloom\CMS\Core\Http\Events\PagePublished', 'code' => 2, 'label' => 'published', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 3, 'nom' => 'Bloom\CMS\Core\Http\Events\PageUnpublished', 'code' => 4, 'label' => 'unpublished', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 4, 'nom' => 'Bloom\CMS\Core\Http\Events\PageDeleted', 'code' => 8, 'label' => 'deleted', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 5, 'nom' => 'Bloom\CMS\Core\Http\Events\PageUrlChange', 'code' => 16, 'label' => 'urlChanged', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 6, 'nom' => 'eloquent.replicating: Bloom\CMS\Core\Http\Page', 'code' => 32, 'label' => 'replicated', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 7, 'nom' => 'Bloom\CMS\Core\Http\Events\PageSaved', 'code' => 64, 'label' => 'pageSaved', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 8, 'nom' => 'Bloom\CMS\Core\Http\Events\SommaireSaved', 'code' => 128, 'label' => 'sommaireSaved', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at, public) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 9, 'nom' => 'eloquent.created: Bloom\CMS\Core\Http\Page', 'code' => 256, 'label' => 'created', 'created_at' => now(), 'updated_at' => now() ]
        );
    }
}
