<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 30/03/2021
 * Time: 16:21
 */

namespace Bloom\Test;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;

/**
 * Class DynaListingProvider
 * @package Bloom\Test
 */
class DynaListingProvider extends BloomProvider
{

    protected $code = 'test';
    protected $nom = 'Test';

    public function boot()
    {
        parent::boot();
        $this->haveGenericIndex(
            (new WorkflowsFactory(Article::class))
                ->add('Publié', "ARTICLE_PUB")
                ->setAction(
                    (new Actions())
                        ->addAction('Modifier', 'admin_test_edit')
                        ->addNewTabAction('Prévisualiser', 'admin_test_preview')
                        ->addAction('Archiver', 'admin_test_archive')
                )->setSubActions(
                    (new Actions())
                        ->addAction('Dupliquer', 'admin_article_duplicate', 'bloomicon-admin-copy')
                        ->addAction('Publier', 'admin_article_publish', 'bloomicon-admin-arrow-up-right')
                        ->addAction('Archiver', 'admin_article_archive', 'bloomicon-admin-archive')
                )->setHeaders(
                    [
                        (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                        (new TableHeader('Id', 'id'))->canOrder(),
                        (new TableHeader('Chemin archi', 'page.pathname')),
                        (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                        (new TableHeader('Modifié le', 'created_at'))
                            ->canOrder()->haveTitle('page.deriere_modification_par.name'),
                        (new TableHeader('Dates de<br> publication', 'to_publish_at'))->canOrder(),
                    ]
                )
                ->push()
        );
    }
}
