<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMiroirIdToSectionLiens extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('section_liens', function (Blueprint $table) {
            $table->dropForeign('section_liens_page_id_foreign');

            $table->unsignedBigInteger('page_id')->nullable()->change();
            $table->unsignedBigInteger('miroir_id')->nullable()->after('page_id');

            $table->foreign(['page_id'])->on('pages')->references('id')->cascadeOnDelete();
            $table->foreign(['miroir_id'])->on('page_dossiers')->references('id')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('section_liens', function (Blueprint $table) {
            $table->dropForeign(['miroir_id']);
            $table->dropForeign(['page_id']);

            $table->dropColumn('miroir_id');
            $table->bigInteger('page_id', false, true)->change();

            $table->foreign(['page_id'])->on('pages')->references('id')->cascadeOnDelete();
        });
    }
}
