<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/06/2021
 * Time: 10:45
 */

namespace Bloom\CMS\Core\Framework\Mails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class BaseMailable extends Mailable
{
    use Queueable, SerializesModels;


    public string $tag;
    public string $fromEmail;
    public string $fromName;
    public array $data;

    /**
     * Create a new message instance.
     * @return void
     */
    public function __construct($view, $subject, $data = [],  $fromEmail =null, $fromName= null, $tag = null)
    {
        $this->view = $view;
        $this->subject = $subject;
        $this->fromEmail = $fromEmail ?? config('mail.from.address');
        $this->fromName = $fromName?? config('mail.from.name');
        $this->tag = $tag ?? config('core.brevo.tag', 'Bloom');
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view($this->view)
            ->subject($this->subject)
            ->from($this->fromEmail, $this->fromName)
            ->with($this->data)
            ->tag($this->tag);

    }



}
