<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 22/03/2021
 * Time: 15:23
 */

namespace Bloom\CMS\Core\Helpers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class WorkflowTransition
 * @package Bloom\CMS\Core\Helpers
 *
 * @property int      from
 * @property int      to
 * @property Workflow origin
 * @property Workflow destination
 * @property string   call
 */
class WorkflowTransition extends Model
{
    /**
     * @return BelongsTo
     */
    public function origin(): BelongsTo
    {
        return $this->belongsTo(Workflow::class, 'from');
    }

    public function destination(): BelongsTo
    {
        return $this->belongsTo(Workflow::class, 'to');
    }

    public function apply(Model $model): void
    {
        $method = $this->call;
        $model->$method();
    }
}
