<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 30/03/2021
 * Time: 12:57
 */

namespace Bloom\CMS\Core\Helpers;

use Bloom\CMS\Core\Framework\Module;

/**
 * Class WorkflowsFactory
 * @package Bloom\CMS\Core\Helpers
 */
final class WorkflowsFactory
{
    /**
     * @var array|Workflow[]
     */
    protected $workflows = [];
    /**
     * @var Workflow
     */
    protected $current;
    /**
     * @var string
     */
    protected $on;

    public function __construct(string $on)
    {
        $this->on = $on;
    }

    /**
     * @param string $titre
     * @param string $code
     * @return $this
     */
    public function add(string $titre, string $code): WorkflowsFactory
    {
        $this->current = new Workflow();
        $this->current->on = $this->on;
        $this->current->titre = $titre;
        $this->current->code = $code;

        return $this;
    }

    /**
     * @return $this
     */
    public function push(): WorkflowsFactory
    {
        $this->workflows[] = $this->current;
        $this->current = null;

        return $this;
    }

    /**
     * @param Actions $action
     * @return $this
     */
    public function setAction(Actions $action): WorkflowsFactory
    {
        $this->current->actions = $action;

        return $this;
    }

    /**
     * @param Actions $actions
     * @return $this
     */
    public function setSubActions(Actions $actions): WorkflowsFactory
    {
        $this->current->sub_actions = $actions;

        return $this;
    }

    /**
     * @param array|TableHeader[] $headers
     * @return $this
     */
    public function setHeaders(array $headers): WorkflowsFactory
    {
        $this->current->headers = $headers;

        return $this;
    }

    /**
     * @param Module $module
     */
    public function saveFor(Module $module)
    {
        foreach ($this->workflows as $workflow) {
            /**
             * @var Workflow $workflow
             */
            // On force l'assiociation du module ici, pour ne pas le faire dans les packages enfants
            $workflow->module()->associate($module);
            $workflow->save();
        }
    }

    /**
     * @param string $sql
     *
     * @return $this
     */
    public function statement(string $sql): WorkflowsFactory
    {
        $this->current->requetes = $sql;

        return $this;
    }
}
