<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 01/12/2020
 * Time: 11:04
 */

namespace Bloom\CMS\Core\Http\Events\Handler;

use Bloom\CMS\Core\Http\Events\PageArchived;
use Bloom\CMS\Core\Http\Events\PageDeleted;
use Bloom\CMS\Core\Http\Events\PagePublished;
use Bloom\CMS\Core\Http\Events\PageUnpublished;

/**
 * Class MiroirHandler
 *
 * @package Bloom\CMS\Core\Http\Events\Handler
 */
class MiroirHandler
{
    public function archived(PageArchived $event)
    {
        if ($event->page->has_miroirs) {
            foreach ($event->page->miroirs as $miroir) {
                $miroir->archive();
            }
        }
    }

    public function published(PagePublished $event)
    {
        if ($event->page->has_miroirs) {
            foreach ($event->page->miroirs as $miroir) {
                $miroir->publish();
            }
        }
    }

    public function unpublished(PageUnpublished $event)
    {
        if ($event->page->has_miroirs) {
            foreach ($event->page->miroirs as $miroir) {
                $miroir->unpublish();
            }
        }
    }

    public function deleted(PageDeleted $event)
    {
        if ($event->page->has_miroirs) {
            foreach ($event->page->miroirs as $miroir) {
                $miroir->softDelete();
            }
        }
    }
}
