<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 05/10/2020
 * Time: 14:45
 */

namespace Bloom\CMS\Core;

use Bloom\CMS\Core\Contenus\Ensemble;
use Bloom\CMS\Core\Contenus\Filtre;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Framework\Commands\ChangeStatutCommand;
use Bloom\CMS\Core\Framework\Commands\DepublicationsCommand;
use Bloom\CMS\Core\Framework\Commands\NotificationsCommnad;
use Bloom\CMS\Core\Framework\Commands\PublicationsCommand;
use Bloom\CMS\Core\Framework\Message\Toast;
use Bloom\CMS\Core\Framework\Message\ToastManager;
use Bloom\CMS\Core\Framework\Twig\CoreExtension;
use Bloom\CMS\Core\Framework\Twig\ToastExtension;
use Bloom\CMS\Core\Http\Events\Subscriber\PageSubscriber;
use Bloom\CMS\Core\Http\Miroir;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Core\Http\Redirect\Redirection;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;
use TwigBridge\Facade\Twig;

class CmsCoreProvider extends BloomProvider
{
    protected $has_admin = false;
    protected $nom = "Core";
    protected $code = "core";

    public function register()
    {
        parent::register();
        Event::subscribe(PageSubscriber::class);
        if ($this->app->environment('testing', 'test')) {
            $this->loadRoutesFrom(dirname(__DIR__) . '/resources/module_test/routes/admin.php');
        }
        $this->commands(
            [
                ChangeStatutCommand::class,
                PublicationsCommand::class,
                DepublicationsCommand::class,
                NotificationsCommnad::class
            ]
        );
        $this->app->singleton('toast', function () {
            return new ToastManager();
        });
    }

    public function boot()
    {
        parent::boot();
        $this->addTwigExtension();
        $morphed = [
            'filtres' => Filtre::class,
            'ensembles' => Ensemble::class,
            'page_statiques' => PageStatique::class,
        ];

        Relation::morphMap($morphed);

        Page::declareContenus($morphed);
        static::refreshRoutes();

        Toast::listen();
    }

    protected function addTwigExtension(): void
    {
        Twig::addExtension(new CoreExtension());
        Twig::addExtension(new ToastExtension());
    }

    public static function refreshRoutes(): void
    {
        if (Schema::hasTable('pages')) {
            Route::group(
                ['namespace' => 'Bloom\CMS\Core\Http\Controllers', 'middleware' => ['web']],
                function () {
                    if (Schema::hasTable('pages')) {
                        foreach (Page::published()->get('pathname') as $page) {
                            Route::get($page->pathname, 'FrontController@handle');
                        }
                    }
                    if (Schema::hasTable('redirections')) {
                        foreach (Redirection::published()->get() as $redirection) {
                            /**
                             * @var Redirection $redirection
                             */
                            Route::get($redirection->source, 'FrontController@redirect');
                        }
                    }
                    if (Schema::hasTable('page_dossiers')) {
                        foreach (Miroir::published()->get() as $miroir) {
                            /**
                             * @var Miroir $miroir
                             */
                            Route::get($miroir->pathname, 'FrontController@miroir');
                        }
                    }
                }
            );
        }
    }
}
