<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMiroirIdToLiens extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('liens', function (Blueprint $table) {
            $table->unsignedBigInteger('miroir_id')->nullable()->after('page_id');

            $table->foreign(['miroir_id'])->on('page_dossiers')->references('id')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('liens', function (Blueprint $table) {
            $table->dropForeign(['miroir_id']);
            $table->dropColumn('miroir_id');
        });
    }
}
