<?php

namespace Bloom\CMS\Core\Framework;

use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Module
 *
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property int                    $id
 * @property string                 $nom
 * @property string                 $nom_public
 * @property string                 $route
 * @property AdminMenu[]|Collection $subMenus
 * @property bool                   $active
 * @property int                    $ordre
 *
 * @property bool                   has_admin
 *
 * @method static Builder nom(string $nom)
 * @method static Builder actif()
 */
class Module extends Model
{
    /**
     * @var bool
     */
    public $menu_actif = false;

    protected $guarded = [];

    public function scopeNom(Builder $query, string $nom)
    {
        return $query->where('nom', '=', $nom);
    }

    public function scopeActif(Builder $query)
    {
        return $query->where('active', '=', 1);
    }

    public function subMenus()
    {
        return $this->hasMany(AdminMenu::class);
    }

    public function getHasAdminAttribute(): bool
    {
        return (string)$this->route !== '';
    }
}
