<?php

namespace Bloom\CMS\Core\Framework\Commands;

use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Praticiens\PraticiensServiceProvider;
use Bloom\CMS\HPV\Specialites\SpecialitesServiceProvider;
use Bloom\CMS\Modules\Actu\Model\Actu;
use Illuminate\Console\Command;

class PageCorrect extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'page:correct';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Associe les pages Actus / Praticiens / Spécialités à leurs dossiers respectifs';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        //Actualités et Catégories
        $dossier_actus = Dossier::where('type', '=', Actu::class)->first();
        Page::withoutEvents( function () use ($dossier_actus) {
            $pages = Page::where(function ($query) {
                $query->where('contenu_type', '=', 'actus')
                    ->orWhere('contenu_type', '=', 'categories');
                })
                ->where(function ($query) use ($dossier_actus) {
                    $query->where('dossier_id', '<>', $dossier_actus->id)
                        ->orWhereNull('dossier_id');
                })
                ->get();

            foreach ($pages as $page) {
                $page->dossier_id = $dossier_actus->id;
                $page->updatePathname();
                $page->save();
            }
        });

        //Praticiens
        $dossier_praticiens = Dossier::where('name', '=', PraticiensServiceProvider::DOSSIER_NAME)->first();
        Page::withoutEvents( function () use ($dossier_praticiens) {
            $praticiens = Page::where('contenu_type', '=', 'praticiens')
                ->where(function ($query) use ($dossier_praticiens) {
                    $query->where('dossier_id', '<>', $dossier_praticiens->id)
                        ->orWhereNull('dossier_id');
                })
                ->get();

            foreach ($praticiens as $praticien) {
                $praticien->dossier_id = $dossier_praticiens->id;
                $praticien->updatePathname();
                $praticien->save();
            }
        });

        //Spécialités
        $dossier_specialites = Dossier::where('name', '=', SpecialitesServiceProvider::DOSSIER_NAME)->first();
        Page::withoutEvents( function () use ($dossier_specialites) {
            $specialites = Page::where('contenu_type', '=', 'specialites')
                ->where(function ($query) use ($dossier_specialites) {
                    $query->where('dossier_id', '<>', $dossier_specialites->id)
                        ->orWhereNull('dossier_id');
                })
                ->get();

            foreach ($specialites as $specialite) {
                $specialite->dossier_id = $dossier_specialites->id;
                $specialite->updatePathname();
                $specialite->save();
            }
        });
    }
}
