<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 06/10/2020
 * Time: 12:17
 */

namespace Bloom\CMS\Core;

use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\View\Factory;
use Orchestra\Testbench\TestCase;
use TwigBridge\Facade\Twig;
use TwigBridge\ServiceProvider;

/**
 * Class Test
 *
 * @package                 Bloom\CMS\Core
 * @SuppressWarnings(PHPMD)
 */
class Test extends TestCase
{
    use DatabaseTransactions;

    /**
     * @var string
     */
    protected $provider;
    /**
     * @var BloomProvider
     */
    protected $module;

    protected $packages = [];

    public function __construct($name = null, array $data = [], $dataName = '')
    {
        parent::__construct($name, $data, $dataName);
    }

    protected function getPackageProviders($app)
    {
        $packages = [ServiceProvider::class, CmsCoreProvider::class];
        if ($this->provider && !in_array($this->provider, $packages)) {
            $packages[] = $this->provider;
        }

        return array_merge($packages,$this->packages);
    }

    protected function getPackageAliases($app)
    {
        return [
            'Twig' => Twig::class
        ];
    }

    /**
     * Setup the test environment.
     */
    protected function setUp(): void
    {
        parent::setUp();
        if (Schema::hasTable('statuts') && DB::table('statuts')->count() === 0) {
            $this->seed(\StatutSeeder::class);
        }
        if (Schema::hasTable('users') && DB::table('users')->count() === 0) {
            $this->seed(\UserSeeder::class);
        }
        if (Schema::hasTable('campagnes') && DB::table('campagnes')->count() === 0) {
            $this->seed(\CampagneSeeder::class);
        }
        $nbMigration = DB::table('migrations')->count();
        $this->artisan('migrate');
        if (is_dir($this->module->getDir() . '/database/testing')) {
            $this->loadMigrationsFrom($this->module->getDir() . '/database/testing');
        }
        $self = $this;
        $this->beforeApplicationDestroyed(function () use ($self, $nbMigration) {
            // On rollback les derniere migrations en cas de modification/test de celle-ci
            $nbMigrationPostApp = DB::table('migrations')->count();
            if ($nbMigration < $nbMigrationPostApp) {
                $self->artisan('migrate:rollback');
            }
        });
    }

    protected function getEnvironmentSetUp($app)
    {
        if ($this->provider) {
            $class = $this->provider;
            $this->module = new $class($app);
        }
        $app['config']->set('database.default', env('DB_CONNECTION'));
        $app['config']->set('filesystems.disks.local.root', dirname(__DIR__) . '/storage');
        $app['config']->set('filesystems.disks.images.driver', 'local');
        $app['config']->set('filesystems.disks.images.root', dirname(__DIR__) . '/storage/images');
        $app['config']->set('app.admin', 'admin');
        $app['config']->set('logging.default', 'stack');
        $app['config']->set(
            'logging.channels.single.path',
            ($this->module ? $this->module->getDir() : dirname(__DIR__)) . '/logs/laravel.log'
        );
        $module = $this->module;
        $app->afterResolving('view', function ($view) use ($module) {
            /**
             * @var Factory $view
             */
            if (is_dir($module->getDir() . '/resources/views_testing')) {
                foreach (scandir($module->getDir() . '/resources/views_testing') as $dir) {
                    if (in_array($dir, ['.', '..'])) {
                        continue;
                    }
                    $view->addNamespace($dir, $module->getDir() . '/resources/views_testing/' . $dir);
                }
            }
            if ($module->getCode() !== 'core') {
                $view->addNamespace('Bloom', $module->getCoreDir() . '/resources/views_testing/Bloom');
            }
        });
    }
}
