<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 11:07
 */

namespace Bloom\CMS\Core\Framework\Commands;

use Bloom\CMS\Core\Framework\Mails\PageMouvementMail;
use Bloom\CMS\Core\Framework\Suivis;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Schema;

/**
 * Class PublicationsCommand
 * @package Bloom\CMS\Core\Framework\Commands
 */
class NotificationsCommnad extends Command
{
    protected $signature = "page:notify
    {--D|dry-run : Fait le tour des pages mais ne les publies pas vraiment, outils pour débug}
    ";
    protected $description = "Notify tous les changement de statut des pages et meas";

    public function handle()
    {
        $suivis = [
            'publish' => Suivis::query()
                ->where('notified', '=', 0)
                ->where('statut_apr', '=', 1)
                ->get()
                ->load('item')
                ->groupBy('item_type'),
            'archive' => Suivis::query()
                ->where('notified', '=', 0)
                ->where('statut_apr', '=', 0)
                ->get()
                ->load('item')
                ->groupBy('item_type')
        ];
        $this->comment('Nb mouvement : ' . ($suivis['publish']->count() + $suivis['archive']->count()));
        $this->comment('Nb publish : ' . ($suivis['publish']->count()));
        $this->comment('Nb archive : ' . ($suivis['archive']->count()));

        if (!$this->option('dry-run')) {
            foreach ($this->fetchMails() as $mail) {
                Mail::to($mail)->send(new PageMouvementMail($suivis));
            }
            foreach ($suivis as $collections) {
                $this->setNotified($collections);
            }
        }

        return 0;
    }

    /**
     * @param Suivis[]|Collection $suivis
     */
    private function setNotified(Collection $suivis): void
    {
        foreach ($suivis as $suivi) {
            foreach ($suivi as $item) {
                $item->notified = 1;
                $item->save();
            }
        }
    }

    private function fetchMails(): array
    {
        if (Schema::hasTable('mails')) {
            $class = '\Bloom\Cms\Notification\Data\Services';
            $service = $class::query()->where('service', '=', 'Publications')->first();
            $mails = [];
            if ($service) {
                $mails = $service->mails
                    ->pluck('mail')
                    ->toArray();
            }
            if ($service === null || count($mails) === 0) {
                // Le module est installé mais le service Publications n'existe pas
                return User::all(['email'])->pluck('email')->toArray();
            }
        }

        return User::all(['email'])->pluck('email')->toArray();
    }
}
