<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 01/12/2020
 * Time: 12:30
 */

namespace Bloom\CMS\Core\Contenus;

use Illuminate\Database\Eloquent\Relations\Relation;
use InvalidArgumentException;

/**
 * Trait HasContenu
 * @package Bloom\CMS\Core\Contenus
 */
trait HasContenu
{
    protected static $contenus = [];

    /**
     * Déclarer un nouveau model Contenu
     *
     * @param string $contenu
     */
    public static function declareContenu(string $contenu): void
    {
        if (!is_subclass_of($contenu, Contenu::class)) {
            $relation = Relation::getMorphedModel($contenu);
            if ($relation === null || !is_subclass_of($relation, Contenu::class)) {
                throw new InvalidArgumentException("$contenu doit implémenté l'interface " . Contenu::class);
            }
        }
        if (!in_array($contenu, static::$contenus)) {
            static::$contenus[] = $contenu;
        }
    }

    public static function declareContenus(array $contenus): void
    {
        foreach ($contenus as $contenu) {
            static::declareContenu($contenu);
        }
    }

    public static function getDeclaredContenu(): array
    {
        return static::$contenus;
    }

    public function contenu()
    {
        return $this->morphTo();
    }

    public function setContenuTypeAttribute(string $value)
    {
        if (!in_array($value, static::$contenus) && $value !== 'page_statiques') {
            throw new InvalidArgumentException('contenu_type must be a declared contenu');
        }

        $this->attributes['contenu_type'] = $value;
    }
}
