<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 11:07
 */

namespace Bloom\CMS\Core\Framework\Commands;

use Bloom\CMS\Core\Contenus\Statut;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Collection;

/**
 * Class PublicationsCommand
 * @package Bloom\CMS\Core\Framework\Commands
 */
class PublicationsCommand extends Command
{
    protected $signature = "page:publish 
    {--D|dry-run : Fait le tour des pages mais ne les publies pas vraiment, outils pour débug}
    {--N|now= : Surcharge la date de comparaison, par défaut prends la date du jour (format Y-m-d)}
    ";
    protected $description = "Publie toutes les pages et meas qui ont un to_publish_at = [now]";

    public function handle()
    {
        $result = $this->call(
            ChangeStatutCommand::class,
            [
                '--dry-run' => $this->option('dry-run') ?: false,
                '--now'     => $this->option('now'),
                'statut'    => Statut::PUBLIE,
                'colonne'   => 'to_publish_at'
            ]
        );
        // On verifie qu'il n'y ai qu'1 seul mea principal
        $meaClass = '\Bloom\CMS\Modules\Meas\Model\Mea';
        if (class_exists($meaClass)) {
            /**
             * @var Collection $meas
             */
            $meas = $meaClass::query()->where('type', '=', 'MAIN')->where('statut_id', '=', Statut::PUBLIE)->get();
            if ($meas->count() > 1) {
                foreach ($meas->sortByDesc('to_publish_at') as $k => $mea) {
                    // Le premier sera celui qui a été le plus récement publié donc on archive les autres
                    if ($k === 0) {
                        continue;
                    }
                    $mea->statut_id = 0;
                    $mea->save();
                }
            }
        }

        return $result;
    }
}
