@extends('bloom.layout.admin')

@php
    use \Carbon\Carbon;
@endphp

@section('bodyClass', 'page-listing')

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            {{--<h1>{{ $contenu|title }}</h1>--}}
            <h1>{{ $contenu }}</h1>

            <a href="{{ route($workflow->route_edit) }}" class="btn btn-grisclair5 btn-primary">
                {{ $workflow->creation_titre }}
            </a>
        </div>

        <div class="content">
            <ul class="list-nav-articles nav nav-pills mb-3">
                @foreach($all as $work)
                    <li class="nav-item">
                        <a href="{{ route($work->module->route, $work) }}"{{ $work->id === $workflow->id ? 'class="active"' : '' }}>
                            <span class="text">{{ $work->titre }}</span>
                            <span class="badge badge-primary badge-pill">{{ $work->number }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>

            <div class="table-responsive">
                <table class="table table-admin">
                    <thead>
                    <tr>
                        @foreach($workflow->headers as $header)
                            @php($way = "asc")
                            @if($order->item === $header->accessor)
                                @php($way = $order->order === "asc" ? "desc" : "asc")
                            @endif
                            <th scope="col">
                                @if($header->can_order)
                                    <a class="order-me @if($order->item === $header->accessor) sort-{{ $way }} @endif"
                                       href="?orderBy={{ $header->accessor }}&order={{ $way }}"
                                    >
                                        <span class="text">{!! $header->titre !!}</span>
                                        <span class="sort">
                                                <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                                <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                            </span>
                                    </a>
                                @else
                                    {{ $header->titre }}
                                @endif
                            </th>
                        @endforeach
                        {{-- Colonne d'action--}}
                        <th scope="col" colspan="2"></th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($contents as $row)
                        @if(count($contents) > 0)
                            <tr>
                                @foreach($workflow->headers as $header)
                                    @php($value = $header->value($row))
                                    @if($header->is_date)
                                        @php($value = Carbon::parse($value)->format('d/m/Y'))
                                    @endif
                                    <td>
                                        @if($header->is_image)
                                            <img src="{{ $header->value($row) }}" alt="" class="img-fluid">
                                        @elseif($header->title)
                                            @php($title = $header->value($row, $header->title))
                                            @if($header->title_date)
                                                @php($title = Carbon::parse($title)->format('d/m/Y'))
                                            @endif
                                            <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                                  data-placement="bottom" title="{{ $title }}">
                                                @if($header->accessor === 'page.to_publish_at')
                                                    @if($row->page->to_publish_at)
                                                        du {{ Carbon::parse($row->page->to_publish_at)->format('d/m/Y') }}
                                                        <br>
                                                        au {{ Carbon::parse($row->page->to_unpublish_at)->format('d/m/Y') }}
                                                    @endif
                                                @else
                                                    {{ $value }}
                                                @endif
                                            </span>
                                        @else
                                            @if($header->accessor === 'page.to_publish_at')
                                                @if($row->page->to_publish_at)
                                                    du {{ Carbon::parse($row->page->to_publish_at)->format('d/m/Y') }}
                                                    <br>
                                                    au {{ Carbon::parse($row->page->to_unpublish_at)->format('d/m/Y') }}
                                                @endif
                                            @else
                                                {{ $value }}
                                            @endif
                                        @endif
                                    </td>
                                @endforeach
                                <td class="btn-group-cta btn-group-sm text-right">
                                    {{-- {{ actionMacro.list(actions, row) }}--}}
                                </td>
                                @if(count($sub_actions) > 0)
                                    <td>
                                        {{-- {{ actionMacro.dropDown("dropdownMenu0"~ loop.index , sub_actions, row) }}--}}
                                    </td>
                                @endif
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection