<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSectionDossiers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('section_dossiers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('section_id', false, true);
            $table->bigInteger('dossier_id', false, true);

            $table->foreign(['section_id'])->on('sections')->references('id')->cascadeOnDelete();
            $table->foreign(['dossier_id'])->on('dossiers')->references('id')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('section_dossiers');
    }
}
