<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 02/12/2020
 * Time: 15:43
 */

namespace Bloom\CMS\Core\Tests\Unit;


use Bloom\CMS\Core\Helpers\Actions;
use PHPUnit\Framework\TestCase;

class ActionTest extends TestCase
{

    public function test_should_convert_to_an_array()
    {
        $action = new Actions('test');

        static::assertEquals(['test' => []], $action->toArray());
    }

    public function test_should_push_an_action_with_default_value()
    {
        $action = new Actions('test');
        $action
            ->addAction('test', 'http://action');
        $expected = [
            'test' => [
                ['name' => 'test', 'href' => 'http://action', 'picto' => 'fa-bolt', 'target' => '_self']
            ]
        ];

        static::assertEquals($expected, $action->toArray());
    }

    public function test_should_add_a_default_name_to_an_action_with_no_name()
    {
        $action = new Actions('test');
        $action
            ->addAction('', 'http://action');
        $expected = [
            'test' => [
                ['name' => 'Action', 'href' => 'http://action', 'picto' => 'fa-bolt', 'target' => '_self']
            ]
        ];

        static::assertEquals($expected, $action->toArray());
    }

    public function test_addNewTabAction_should_target_blank()
    {
        $action = new Actions('test');
        $action
            ->addNewTabAction('TEst', 'http://action');
        $expected = [
            'test' => [
                ['name' => 'TEst', 'href' => 'http://action', 'picto' => 'fa-bolt', 'target' => '_blank']
            ]
        ];
        static::assertEquals($expected, $action->toArray());
    }
}
