<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EventSeeder extends Seeder
{
    public function run()
    {
        DB::table('events')->truncate();
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 1, 'nom' => 'Bloom\CMS\Core\Http\Events\PageArchived', 'code' => 1, 'label' => 'archived', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 2, 'nom' => 'Bloom\CMS\Modules\Meas\Http\Events\MeaArchived', 'code' => 1, 'label' => 'archived', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 3, 'nom' => 'Bloom\CMS\Modules\Menu\Http\Events\MenuArchived', 'code' => 1, 'label' => 'archived', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 4, 'nom' => 'Bloom\CMS\HPV\Cliniques\Http\Events\CliniqueArchived', 'code' => 1, 'label' => 'archived', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            ['id' => 5, 'nom' => 'Bloom\CMS\Core\Http\Events\PagePublished', 'code' => 2, 'label' => 'published', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            ['id' => 6, 'nom' => 'Bloom\CMS\Modules\Meas\Http\Events\MeaPublished', 'code' => 2, 'label' => 'published', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            ['id' => 7, 'nom' => 'Bloom\CMS\Modules\Menu\Http\Events\MenuPublished', 'code' => 2, 'label' => 'published', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            ['id' => 8, 'nom' => 'Bloom\CMS\HPV\Cliniques\Http\Events\CliniquePublished', 'code' => 2, 'label' => 'published', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 9, 'nom' => 'Bloom\CMS\Core\Http\Events\PageUnpublished', 'code' => 4, 'label' => 'unpublished', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 10, 'nom' => 'Bloom\CMS\Modules\Meas\Http\Events\MeaUnpublished', 'code' => 4, 'label' => 'unpublished', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 11, 'nom' => 'Bloom\CMS\Modules\Menu\Http\Events\MenuUnpublished', 'code' => 4, 'label' => 'unpublished', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 12, 'nom' => 'Bloom\CMS\HPV\Cliniques\Http\Events\CliniqueUnpublished', 'code' => 4, 'label' => 'unpublished', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 13, 'nom' => 'Bloom\CMS\Core\Http\Events\PageDeleted', 'code' => 8, 'label' => 'deleted', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 14, 'nom' => 'Bloom\CMS\Modules\Meas\Http\Events\MeaDeleted', 'code' => 8, 'label' => 'deleted', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 15, 'nom' => 'Bloom\CMS\Modules\Menu\Http\Events\MenuDeleted', 'code' => 8, 'label' => 'deleted', 'created_at' => now(), 'updated_at' => now() ]
        );

        $this->insert();
    }

    public function insert()
    {
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 16, 'nom' => 'Bloom\CMS\HPV\Cliniques\Http\Events\CliniqueDelete', 'code' => 8, 'label' => 'deleted', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 17, 'nom' => 'Bloom\CMS\Core\Http\Events\PageUrlChange', 'code' => 16, 'label' => 'urlChanged', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 18, 'nom' => 'eloquent.replicating: Bloom\CMS\Core\Http\Page', 'code' => 32, 'label' => 'replicated', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 19, 'nom' => 'eloquent.replicating: Bloom\CMS\Modules\Meas\Model\Mea', 'code' => 32, 'label' => 'replicated', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 20, 'nom' => 'eloquent.replicating: Bloom\CMS\Modules\Menu\Model\Menu', 'code' => 32, 'label' => 'replicated', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 21, 'nom' => 'eloquent.replicating: Bloom\CMS\HPV\Cliniques\Model\Clinique', 'code' => 32, 'label' => 'replicated', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 22, 'nom' => 'Bloom\CMS\Core\Http\Events\PageSaved', 'code' => 64, 'label' => 'saved', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 23, 'nom' => 'eloquent.saved: Bloom\CMS\Modules\Meas\Model\Mea', 'code' => 64, 'label' => 'saved', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 24, 'nom' => 'eloquent.saved: Bloom\CMS\Modules\Menu\Model\Menu', 'code' => 64, 'label' => 'saved', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 25, 'nom' => 'eloquent.saved: Bloom\CMS\HPV\Cliniques\Model\Clinique', 'code' => 64, 'label' => 'saved', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 26, 'nom' => 'Bloom\CMS\Core\Http\Events\SommaireSaved', 'code' => 128, 'label' => 'sommaireSaved', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 27, 'nom' => 'eloquent.created: Bloom\CMS\Core\Http\Page', 'code' => 256, 'label' => 'created', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 28, 'nom' => 'eloquent.created: Bloom\CMS\Modules\Meas\Model\Mea', 'code' => 256, 'label' => 'created', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 29, 'nom' => 'eloquent.created: Bloom\CMS\Modules\Menu\Model\Menu', 'code' => 256, 'label' => 'created', 'created_at' => now(), 'updated_at' => now() ]
        );
        DB::insert(
            'INSERT INTO events (id, nom, code, label, created_at, updated_at) VALUES (:id, :nom, :code, :label, :created_at, :updated_at)',
            [ 'id' => 30, 'nom' => 'eloquent.created: Bloom\CMS\HPV\Cliniques\Model\Clinique', 'code' => 256, 'label' => 'created', 'created_at' => now(), 'updated_at' => now() ]
        );
    }
}
