<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSuivis extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(
            'suivis',
            function (Blueprint $table) {
                $table->id();
                $table->bigInteger('item_id')->unsigned();
                $table->string('item_type');
                $table->integer('statut_avt');
                $table->integer('statut_apr');
                $table->boolean('notified')->default(0);
                $table->timestamps();
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suivis');
    }
}
