<?php


namespace Bloom\CMS\Core\Tests\Feature;

use Bloom\Test\SubMenuProvider;
use Tests\TestCase;

class CMSCoreTest extends TestCase
{
//    public function test_module_core_ok()
//    {
//        $this->assertDatabaseHas('modules', [
//            'nom'        => 'core',
//            'nom_public' => 'Core',
//            'route'      => '',
//            'active'     => 1,
//            'ordre'     => 0,
//            'access'     => 9,
//        ]);
//    }

    public function test_should_insert_only_once_in_admin_menus()
    {
        DB::table('admin_menus')->truncate();
        $this->app->register(SubMenuProvider::class);

        $this->assertDatabaseHas('modules', [
            'nom'        => 'test',
            'nom_public' => 'Test',
            'route'      => 'admin_test_index',
            'active'     => 1,
        ]);

        $this->assertDatabaseHas('admin_menus', [
            'route' => 'admin_test_index',
            'label' => 'Un menu'
        ]);

        $this->assertDatabaseCount('admin_menus', 1);

        $module = $this->app->register(SubMenuProvider::class);

        // On force le boot du module
        $module->boot();

        $this->assertDatabaseCount('admin_menus', 1);
    }
}
