<?php

/**
 * Created by : loic
 * Created at : 28/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Core\Helpers;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;

class Actions implements Arrayable, Jsonable
{
    private $name;
    private $actions = [];

    public function __construct(string $name = 'actions')
    {
        $this->name = $name;
    }

    /**
     * @param string      $name
     * @param string      $href
     * @param string|null $picto
     *
     * @return $this
     */
    public function addAction(string $name, string $href, string $picto = null): Actions
    {
        return $this->pushAction(compact('name', 'href', 'picto'));
    }

    protected function pushAction(array $action): Actions
    {
        static $default;
        if ($default === null) {
            $default = ['name' => 'Action', 'href' => '', 'picto' => 'fa-bolt', 'target' => '_self'];
        }

        foreach ($default as $name => $item) {
            if (!array_key_exists($name, $action) || $action[$name] === null || $action[$name] === '') {
                $action[$name] = $item;
            }
        }

        $this->actions[] = $action;

        return $this;
    }

    public function addNewTabAction(string $name, string $href, string $picto = null): Actions
    {
        $action = compact('name', 'href', 'picto');
        $action['target'] = '_blank';

        return $this->pushAction($action);
    }

    /**
     * @inheritDoc
     */
    public function toArray()
    {
        return [
            $this->name => $this->actions
        ];
    }

    /**
     * @inheritDoc
     */
    public function toJson($options = 0)
    {
        return json_encode($this->toArray(), $options);
    }
}
