<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 13/10/2020
 * Time: 11:56
 */

namespace Bloom\CMS\Core\Http\Controllers;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\Ensemble;
use Bloom\CMS\Core\Http\Indexes\Section;
use Bloom\CMS\Core\Http\Miroir;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Core\Http\Redirect\Redirection;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Bloom\Cms\Sites\Helpers\SiteHelper;

/**
 * Class FrontController
 * @package Bloom\CMS\Core\Http\Controllers
 */
class FrontController
{
    public function handle(Request $request, SiteHelper $siteHelper)
    {
        $path = $request->getPathInfo();

        $page = Page::where('pathname', '=', $path)->firstOrFail();
        $request->session()->forget('canonical_link');
        if ($page->sites()->count() > 0 && !$siteHelper->isCurrentSiteAllowed($page)) {
            abort(404);
        }

        return $this->displayContent($page);
    }

    public function redirect(Request $request, SiteHelper $siteHelper)
    {
        $path = $request->getPathInfo();

        $redirection = Redirection::published()->where('source', '=', $path)->first();
        $hard = $redirection->hard;
        while ($redirect = Redirection::published()->where('source', '=', $redirection->cible)->first()) {
            $hard = $hard || $redirect->hard;
            $redirection = $redirect;
        }
        if ($redirection->sites()->count() > 0 && !$siteHelper->isCurrentSiteAllowed($redirection)) {
            abort(404);
        }
        return redirect($redirection->cible, $hard ? Response::HTTP_MOVED_PERMANENTLY : Response::HTTP_FOUND);
    }

    public function miroir(Request $request)
    {
        $path = $request->getPathInfo();

        /**
         * @var Miroir $miroir
         */
        $miroir = Miroir::where('pathname', '=', $path)->firstOrFail();
        $page = $miroir->page;
        $request->session()->put('canonical_link', $page->pathname);
        if ($miroir->dossier) {
            $dossier = $miroir->dossier;
            $fil_miroir = array(
                ['name' => $dossier->name, 'url' => $dossier->full_pathname],
                ['name' => $page->titre, 'url' => '']);
            view()->share('fil_miroir', $fil_miroir);
        }

        return $this->displayContent($page);
    }

    protected function displayContent(Page $page)
    {
        if ($page->is_index && $page->contenu_type !== 'page_statiques') {
            $breadcrumbElements = [
                ['name' => '', 'url' => ''],
            ];
            $noindex = $page->noindex === 1;
            if ($page->dossier) {
                $dossier = $page->dossier;
                while ($dossier !== null) {
                    $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                    $dossier = $dossier->parent;
                    if (!is_null($dossier) && $dossier->noindex === 1) {
                        $noindex = true;
                    }
                }
            }
            $breadcrumbElements = array_reverse($breadcrumbElements);
            $sections = Section::query()->where('page_id', '=', $page->id)->orderBy('rang')->get();

            if ($sections->count() === 0) {
                // Index auto
                $pages = $page->dossier->pages()->published()->where('id', '!=', $page->id)->get();
                $mirroirs = Miroir::where('dossier_id', '=', $page->dossier_id)->published()->get();

                return view('Archi::front.index_auto', compact('page', 'breadcrumbElements', 'pages', 'mirroirs', 'noindex'));
            }

            $sections = Section::query()->where('page_id', '=', $page->id)->orderBy('rang')->get();

            return view('Archi::front.index_perso', compact('page', 'breadcrumbElements', 'sections', 'noindex'));
        }

        switch ($page->multiplicity) {
            case Page::SINGLE:
                return $page->contenu->getHandler()->single($page->contenu);
            case Page::ALL:
                /**
                 * @var Ensemble $ensemble
                 */
                $ensemble = $page->contenu;
                $model = $ensemble->type;
                /**
                 * @var Contenu $contenu
                 */
                $contenu = new $model();

                return $contenu->getHandler()->ensemble();
            case Page::MUTLI:
                break;
        }

        return abort(404);
    }
}
