<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 02/12/2020
 * Time: 10:41
 */

namespace Tests\Feature;

use Bloom\CMS\Core\CmsCoreProvider;
use Bloom\CMS\Core\Test;
use Bloom\Test\NoAdminProvider;
use Bloom\Test\SubMenuProvider;
use Bloom\Test\TestProvider;
use Illuminate\Support\ServiceProvider;

class BloomProviderTest extends Test
{
    protected $provider = CmsCoreProvider::class;

    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();
        $dir = dirname(__DIR__, 2) . '/resources/module_test/src/';
        foreach (scandir($dir) as $f) {
            if (in_array($f, ['.', '..'])) {
                continue;
            }
            require_once $dir . '/' . $f;
        }
    }


    public function test_should_insert_into_module()
    {
        $this->app->register(TestProvider::class);

        $this->assertDatabaseHas('modules', [
            'nom'        => 'test',
            'nom_public' => 'Test',
            'route'      => 'admin_test_index',
            'active'     => 1,
        ]);
    }

    public function test_should_not_set_route_for_non_admin_module()
    {
        $this->app->register(NoAdminProvider::class);

        $this->assertDatabaseHas('modules', [
            'nom'        => 'test',
            'nom_public' => 'Test',
            'route'      => '',
            'active'     => 1,
        ]);
    }

    public function test_should_insert_only_once_in_admin_menus()
    {
        $this->app->register(SubMenuProvider::class);

        $this->assertDatabaseHas('modules', [
            'nom'        => 'test',
            'nom_public' => 'Test',
            'route'      => 'admin_test_index',
            'active'     => 1,
        ]);

        $this->assertDatabaseHas('admin_menus', [
            'route' => 'admin_test_index',
            'label' => 'Un menu'
        ]);

        $this->assertDatabaseCount('admin_menus', 1);

        $module = $this->app->register(SubMenuProvider::class);

        // On force le boot du module
        $module->boot();

        $this->assertDatabaseCount('admin_menus', 1);
    }

    public function test_should_declare_assets_automatically()
    {
        /**
         * @var TestProvider $provider
         */
        $provider = $this->app->register(TestProvider::class);
        // Le chemin de départs est en clé, le chemin d'arrivé en valeur dans ServiceProvider::$publishGroups
        static::assertContains($provider->getDir() . '/public', array_keys(ServiceProvider::$publishGroups['assets']));
    }

    public function test_should_load_config_automatically()
    {
        /**
         * @var TestProvider $provider
         */
        $provider = $this->app->register(TestProvider::class);
        $config = require $provider->getDir() . '/config/test.php';
        static::assertEquals($config['test'], config('test.test'));
    }
}
