<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 01/12/2020
 * Time: 11:00
 */

namespace Bloom\CMS\Core\Http\Events\Subscriber;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Events\Handler\MiroirHandler;
use Bloom\CMS\Core\Http\Events\Handler\PageHandler;
use Bloom\CMS\Core\Http\Events\PageArchived;
use Bloom\CMS\Core\Http\Events\PageDeleted;
use Bloom\CMS\Core\Http\Events\PagePublished;
use Bloom\CMS\Core\Http\Events\PageStatutChange;
use Bloom\CMS\Core\Http\Events\PageUnpublished;
use Bloom\CMS\Core\Http\Events\PageUrlChange;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Support\Facades\Event;

class PageSubscriber
{
    public function subscribe()
    {
        return [
            PageArchived::class               => [
                [MiroirHandler::class, 'archived']
            ],
            PageDeleted::class                => [
                [MiroirHandler::class, 'deleted']
            ],
            PagePublished::class              => [
                [MiroirHandler::class, 'published']
            ],
            PageUnpublished::class            => [
                [MiroirHandler::class, 'unpublished']
            ],
            PageStatutChange::class           => [
                [PageHandler::class, 'statutChanged']
            ],
            PageUrlChange::class              => [
                [PageHandler::class, 'urlChanged']
            ],
            'eloquent.saving: ' . Page::class => [
                [PageHandler::class, 'saving']
            ]
        ];
    }
}
