<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 02/12/2020
 * Time: 11:14
 */

namespace Bloom\CMS\Core\Tests\Unit;

use Bloom\CMS\Core\CmsCoreProvider;
use Bloom\Test\TestProvider;
use PHPUnit\Framework\TestCase;

class BloomProviderTest extends TestCase
{
    protected $provider = CmsCoreProvider::class;

    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();
        $dir = dirname(__DIR__, 2) . '/resources/module_test/src/';
        foreach (scandir($dir) as $f) {
            if (in_array($f, ['.', '..'])) {
                continue;
            }
            require_once $dir . '/' . $f;
        }
    }

    public function test_set_directory()
    {
        $expected = dirname(__DIR__, 2) . '/resources/module_test';
        $provider = new TestProvider($this->app);

        static::assertEquals($expected, $provider->getDir());
    }

    public function test_set_core_dir()
    {
        $expected = dirname(__DIR__, 2);
        $provider = new TestProvider($this->app);

        static::assertEquals($expected, $provider->getCoreDir());
    }
}
