<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 22/03/2021
 * Time: 15:58
 */

namespace Bloom\CMS\Core\Http\Controllers;

use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Illuminate\View\View;

/**
 * Class AdminController
 * @package Bloom\CMS\Core\Http\Controllers
 *
 *
 */
class AdminController
{
    /**
     * renvoie l'id du module actif  (en cours d'utilisation)
     * @return int
     */
    public function getModuleActif(): int
    {
        $request_uri = request()->server->get('REQUEST_URI');

        //liste modules
        $modules = Module::actif()->get();
        $module_actif = 1;
        foreach ($modules as $module) {
            $module['subMenus'] =$module->subMenus()->get(); // liste des routes de chaque menu

            if(empty($module_actif) && !str_contains($module->nom, 'core') ){
                // initialise le module actif avec le premier module (excepté le core)
                $module_actif = $module->id;
            }

            if(str_contains($request_uri, $module->nom)){
                // set le module qui correspond à la route demandée
                $module_actif = $module->id;
            }
        }

        return $module_actif;
    }
    /**
     * @param ?Workflow $workflow
     *
     * @return View
     */
    public function listing(Workflow $workflow = null)
    {

        $request = request();
        if ($workflow === null) {
            // Cas d'index par défaut sans précision de workflow
            // On va chargé le premier
            $workflow = Workflow::isModule($this->getModuleActif())
                ->orderBy('ordre')
                ->first();
        }
        // On charge tous les workflow
        $all = Workflow::isModule($this->getModuleActif())
            ->where('on', '=', $workflow->on)
            ->orderBy('ordre')
            ->with('module')
            ->get();

        $order = [
            'order' => request('order'),
            'item'  => request('orderBy')
        ];

        $contents = $workflow->contents;

        // On ordonne les donneés en fonction de l'ordre demandé
        if ($order['item']) {
            if (strtoupper($order['order']) === 'ASC') {
                $contents = $contents->sortBy($order['item']);
            } else {
                $contents = $contents->sortByDesc($order['item']);
            }
        }
        return view(
            'Core::admin.listing',
            [
                'contents' => $contents,
                'workflow' => $workflow,
                'all'      => $all,
                'contenu'  => $workflow->module->nom_public,
                'order'    => $order,
                'sub_actions' => $workflow->sub_actions->toArray()['actions'],
                'actions' => $workflow->actions->toArray()['actions'],
            ]
        );
    }
}
