<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRedirections extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('redirections', function (Blueprint $table) {
            $table->id();
            $table->string('source');
            $table->string('cible');
            $table->string('query_string');
            $table->boolean('hard');
            $table->bigInteger('created_by')->unsigned();
            $table->bigInteger('updated_by')->unsigned();
            $table->integer('statut_id')->unsigned();
            $table->timestamps();

            $table->foreign(['created_by'])->references('id')->on('users');
            $table->foreign(['updated_by'])->references('id')->on('users');
        });

        Schema::create('campagnes', function (Blueprint $table) {
            $table->id();
            $table->string('nom');
            $table->bigInteger('created_by')->unsigned();
            $table->bigInteger('updated_by')->unsigned();
            $table->timestamps();

            $table->foreign(['created_by'])->references('id')->on('users');
            $table->foreign(['updated_by'])->references('id')->on('users');
        });

        Schema::create('campagne_redirections', function (Blueprint $table) {
            $table->bigInteger('campagne_id')->unsigned();
            $table->bigInteger('redirection_id')->unsigned();
            $table->bigInteger('created_by')->unsigned();
            $table->bigInteger('updated_by')->unsigned();

            $table->timestamps();

            $table->foreign(['created_by'])->references('id')->on('users');
            $table->foreign(['updated_by'])->references('id')->on('users');
            $table->foreign(['campagne_id'])->references('id')->on('campagnes')->cascadeOnDelete();
            $table->foreign(['redirection_id'])->references('id')->on('redirections')->cascadeOnDelete();

            $table->primary(['campagne_id', 'redirection_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('redirections');
        Schema::dropIfExists('campagnes');
        Schema::dropIfExists('campagne_redirections');
    }
}
