<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 15:52
 */

namespace Bloom\CMS\Core\Framework\Twig;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Framework\Module;
use Bloom\CMS\Core\Http\Miroir;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Database\Eloquent\Collection;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Twig\TwigTest;
use Twig\TwigFilter;

/**
 * Class CoreExtensionextends
 * @package Bloom\CMS\Core\Framework\Twig
 */
class CoreExtension extends AbstractExtension
{
    public function getFunctions()
    {
        return [
            new TwigFunction(
                'modules',
                function () {
                    return Module::actif()->get()->each(
                        function (Module $module) {
                            $module->menu_actif = request()->module_actif == $module->id;
                        }
                    );
                }
            ),
            new TwigFunction(
                'route_name',
                function () {
                    return request()->route()->getName();
                }
            )
            ,
            new TwigFunction(
                'request',
                function () {
                    return request();
                }
            ),
            new TwigFunction('concession', function () {
                static $concession;
                if ($concession === null) {
                    $code_concession = SiteHelper::getCurrentSite()->concession->code_concession;
                    $url = "https://services-honda.kora.pro/auto/dealer/" . $code_concession . ".json?X-CALLEE=51681906-aad7-4e04-b6e8-b52a48a3";
                    $concession = Http::get($url)->json();
                }

                return $concession;
            }),
            new TwigFunction('dealer', function () {
                static $dealer;
                if ($dealer === null) {
                    if (config('sites.multi_sites')) {
                        $dealer = SiteHelper::getSiteConcession();
                    } else {
                        $dealer = Concession::first();
                    }
                }

                return $dealer;
            }),
            new TwigFunction('membres', function ($concession_id = 1) {
                static $membres;
                if ($membres === null) {
                    $membres = new MembreRepository(new Membre());
                }
                if (config('sites.multi_sites')) {
                    $concession = SiteHelper::getSiteConcession();
                    if (!is_null($concession)) {
                        $concession_id = $concession->id;
                    }
                }

                return $membres->getPublished($concession_id);
            }),
            new TwigFunction('services', function ($concession_id = 1) {
                static $services;
                if ($services === null) {
                    $services = new ServiceRepository(new Service());
                }
                if (config('sites.multi_sites')) {
                    $concession = SiteHelper::getSiteConcession();
                    if (!is_null($concession)) {
                        $concession_id = $concession->id;
                    }
                }

                return $services->getPublished($concession_id);
            }),
            new TwigFunction('site', function () {
                return SiteHelper::getCurrentSite();
            }),
            new TwigFunction('getStaticBreadcrumb', function ($title) {
                $breadcrumb[] = ['name' => $title, 'url' => null];
                return $breadcrumb;
            }),
        ];
    }

    public function getFilters(): array
    {
        return [
            new TwigFilter('preg_replace', function ($string, $preg, $replace) {
                $val = preg_replace($preg, $replace, $string);
                if (is_numeric($val)) {
                    return (float)$val;
                }

                return $val;
            }),
            new TwigFilter('slugify', function ($string) {
                return Str::slug($string);
            }),
            new TwigFilter('sites', function ($resources) {
                return SiteHelper::filter($resources);
            }),
        ];
    }

    public function getTests()
    {
        return [
            new TwigTest(
                'applicable',
                function (Collection $stickIns) {
                    $page = request()->getPathInfo();
                    $type = '';
                    if ($page === "/") {
                        $type = 'home';
                    } elseif ((string)request()->route()->getName() === '') {
                        $path = request()->getPathInfo();

                        /**
                         * @var Page $page
                         */
                        $page = Page::query()->where('pathname', '=', $path)->first();
                        if ($page === null) {
                            // Si la page existe pas on va check les copie par référence
                            /**
                             * @var Miroir $miroir
                             */
                            $miroir = Miroir::query()->where('pathname', '=', $path)->firstOrFail();
                            $page = $miroir->page;
                        }
                        if ($page->contenu) {
                            $type = get_class($page->contenu);
                        }
                    } else {
                        foreach (request()->route()->parameters() as $parameter) {
                            if ($parameter instanceof Contenu) {
                                $type = get_class($parameter);
                            }
                        }
                    }
                    foreach ($stickIns as $stickIn) {
                        if ($stickIn->contenu_type === $type || (is_object($page) && $stickIn->page_id == $page->id)) {
                            return true;
                        }
                    }

                    return false;
                }
            )
        ];
    }
}
