<?php

namespace Bloom\CMS\Core\Framework\Message;

use Illuminate\Database\Eloquent\Concerns\HasAttributes;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Schema;

/**
 * Class ToastManager
 * @package Bloom\CMS\Core\Framework\Message
 *
 * @property int $events
 */
class ToastManager
{
    use HasAttributes;

    /**
     * Dynamically retrieve attributes on the model.
     *
     * @param  string  $key
     * @return mixed
     */
    public function __get($key)
    {
        return $this->getAttribute($key);
    }

    /**
     * Dynamically set attributes on the model.
     *
     * @param  string  $key
     * @param  mixed  $value
     * @return void
     */
    public function __set($key, $value)
    {
        $this->setAttribute($key, $value);
    }

    public function getEventsAttribute()
    {
        return Request::session()->get('event_code', 0);
    }

    public function getIncrementing()
    {
        return false;
    }

    public function usesTimestamps()
    {
        return false;
    }

    public function setEventsAttribute(int $newVal)
    {
        Request::session()->flash('event_code', $newVal);
    }

    public function listen()
    {
        if (!Schema::hasTable('events')) {
            return;
        }

        $events = \Bloom\CMS\Core\Framework\Event::all();

        foreach ($events as $event) {
            Event::listen($event->nom, function () use ($event) {
                $this->events += $event->code;
            });
        }
    }

    public function show(): string
    {
        $toasts = \Bloom\CMS\Core\Framework\Toast::where('type', 'inclusif')->get();

        foreach ($toasts as $toast) {
            if ($toast->declencheur === $this->events) {
                return $toast->message;
            }
        }

        $toasts = \Bloom\CMS\Core\Framework\Toast::where('type', 'strict')->get();

        foreach ($toasts as $toast) {
            if ($toast->declencheur === $this->events) {
                return $toast->message;
            }
        }

        return 'rien';
    }
}
