<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 15:52
 */

namespace Bloom\CMS\Core\Framework\Twig;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Framework\Module;
use Bloom\CMS\Core\Http\Miroir;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Database\Eloquent\Collection;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Twig\TwigTest;

/**
 * Class CoreExtensionextends
 * @package Bloom\CMS\Core\Framework\Twig
 */
class CoreExtension extends AbstractExtension
{
    public function getFunctions()
    {
        return [
            new TwigFunction(
                'modules',
                function () {
                    return Module::actif()->get()->each(
                        function (Module $module) {
                            $module->menu_actif = request()->module_actif == $module->id;
                        }
                    );
                }
            ),
            new TwigFunction(
                'route_name',
                function () {
                    return request()->route()->getName();
                }
            )
        ];
    }

    public function getTests()
    {
        return [
            new TwigTest(
                'applicable',
                function (Collection $stickIns) {
                    $page = request()->getPathInfo();
                    $type = '';
                    if ($page === "/") {
                        $type = 'home';
                    } elseif ((string)request()->route()->getName() === '') {
                        $path = request()->getPathInfo();

                        /**
                         * @var Page $page
                         */
                        $page = Page::query()->where('pathname', '=', $path)->first();
                        if ($page === null) {
                            // Si la page existe pas on va check les copie par référence
                            /**
                             * @var Miroir $miroir
                             */
                            $miroir = Miroir::query()->where('pathname', '=', $path)->firstOrFail();
                            $page = $miroir->page;
                        }
                        if ($page->contenu) {
                            $type = get_class($page->contenu);
                        }
                    } else {
                        foreach (request()->route()->parameters() as $parameter) {
                            if ($parameter instanceof Contenu) {
                                $type = get_class($parameter);
                            }
                        }
                    }
                    foreach ($stickIns as $stickIn) {
                        if ($stickIn->contenu_type === $type || (is_object($page) && $stickIn->page_id == $page->id)) {
                            return true;
                        }
                    }

                    return false;
                }
            )
        ];
    }
}
