<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 11:07
 */

namespace Bloom\CMS\Core\Framework\Commands;

use Bloom\CMS\Core\Framework\Mails\PageMouvementMail;
use Bloom\CMS\Core\Framework\Suivis;
use Illuminate\Console\Command;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Schema;

/**
 * Class PublicationsCommand
 * @package Bloom\CMS\Core\Framework\Commands
 */
class NotificationsCommnad extends Command
{
    protected $signature = "page:notify 
    {--D|dry-run : Fait le tour des pages mais ne les publies pas vraiment, outils pour débug}
    ";
    protected $description = "Notify tous les changement de statut des pages et meas";

    public function handle()
    {
        $suivis = Suivis::query()->where('notified', '=', 0)->get()->load('item')->groupBy('item_type');
        $this->comment('Nb mouvement : ' . $suivis->count());

        foreach ($this->fetchMails() as $mail) {
            Mail::to($mail)->send(new PageMouvementMail($suivis));
        }

        return 0;
    }

    private function fetchMails(): array
    {
        if (Schema::hasTable('mails')) {
            $service = DB::table('services')->where('service', '=', 'Publications')->first();
            if ($service === null) {
                // Le module est installé mais le service Publications n'existe pas
                return User::all(['email'])->pluck('email')->toArray();
            }

            return DB::table('mails')
                ->joinWhere('mails_services', 'mails_serivces.mails_id', '=', 'mails.id')
                ->where('services_id', '=', $service->id)
                ->get(['mail'])
                ->pluck('mail')
                ->toArray();
        }

        return User::all(['email'])->pluck('email')->toArray();
    }
}
