<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 05/10/2020
 * Time: 14:45
 */

namespace Bloom\CMS\Core;

use Bloom\CMS\Core\Contenus\Ensemble;
use Bloom\CMS\Core\Contenus\Filtre;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Framework\Module;
use Bloom\CMS\Core\Http\Events\Subscriber\PageSubscriber;
use Bloom\CMS\Core\Http\Miroir;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Core\Http\Redirect\Redirection;
use Bloom\CMS\Modules\Architecture\Contenus\Contenu;
use Bloom\CMS\Modules\Menu\Model\StickIn;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Twig\TwigTest;
use TwigBridge\Facade\Twig;

class CmsCoreProvider extends BloomProvider
{
    protected $has_admin = false;
    protected $nom = "Core";
    protected $code = "core";

    public function register()
    {
        parent::register();
        Event::subscribe(PageSubscriber::class);
        if ($this->app->environment('testing', 'test')) {
            $this->loadRoutesFrom(dirname(__DIR__) . '/resources/module_test/routes/admin.php');
        }
    }

    public function boot()
    {
        parent::boot();
        $this->addTwigExtension();
        $morphed = [
            'filtres'        => Filtre::class,
            'ensembles'      => Ensemble::class,
            'page_statiques' => PageStatique::class,
        ];

        Relation::morphMap($morphed);

        Page::declareContenus($morphed);
        static::refreshRoutes();
    }

    protected function addTwigExtension(): void
    {
        Twig::addExtension(
            new class extends AbstractExtension {
                public function getFunctions()
                {
                    return [
                        new TwigFunction('modules', function () {
                            return Module::actif()->get()->each(
                                function (Module $module) {
                                    $module->menu_actif = request()->module_actif == $module->id;
                                }
                            );
                        }),
                        new TwigFunction('route_name', function () {
                            return request()->route()->getName();
                        })
                    ];
                }
                
                public function getTests()
                {
                    return [
                        new TwigTest('applicable', function (Collection $stickIns) {
                            /**
                             * @var StickIn[]|Collection $stickIns
                             */
                            $page = request()->getPathInfo();
                            $type = '';
                            if ($page === "/") {
                                $type = 'home';
                            } elseif ((string)request()->route()->getName() === '') {
                                $path = request()->getPathInfo();

                                /**
                                 * @var \Bloom\CMS\Modules\Architecture\Model\Page $page
                                 */
                                $page = Page::where('pathname', '=', $path)->first();
                                if($page === null) {
                                    // Si la page existe pas on va check les copie par référence
                                    /**
                                     * @var \Bloom\CMS\Modules\Architecture\Model\Miroir $miroir
                                     */
                                    $miroir = Miroir::query()->where('pathname','=',$path)->firstOrFail();
                                    $page = $miroir->page;
                                }
                                if($page->contenu) {
                                    $type = get_class($page->contenu);
                                }
                            } else {
                                foreach (request()->route()->parameters() as $parameter) {
                                    if ($parameter instanceof Contenu) {
                                        $type = get_class($parameter);
                                    }
                                }
                            }
                            foreach ($stickIns as $stickIn) {
                                if ($stickIn->contenu_type === $type) {
                                    return true;
                                }
                            }

                            return false;
                        })
                    ];
                }
            }
        );
    }

    public static function refreshRoutes(): void
    {
        if (Schema::hasTable('pages')) {
            Route::group(
                ['namespace' => 'Bloom\CMS\Core\Http\Controllers', 'middleware' => ['web']],
                function () {
                    if (Schema::hasTable('pages')) {
                        foreach (Page::published()->get('pathname') as $page) {
                            Route::get($page->pathname, 'FrontController@handle');
                        }
                    }
                    if (Schema::hasTable('redirections')) {
                        foreach (Redirection::published()->get() as $redirection) {
                            /**
                             * @var Redirection $redirection
                             */
                            Route::get($redirection->source, 'FrontController@redirect');
                        }
                    }
                    if (Schema::hasTable('page_dossiers')) {
                        foreach (Miroir::published()->get() as $miroir) {
                            /**
                             * @var Miroir $miroir
                             */
                            Route::get($miroir->pathname, 'FrontController@miroir');
                        }
                    }
                }
            );
        }
    }
}
