<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 14/09/2020
 * Time: 11:34
 */

namespace Bloom\CMS\Core\Http\Redirect;

use Bloom\CMS\Core\Contenus\IsUserTracked;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

/**
 * Class Redirection
 *
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property string                source
 * @property string                cible
 * @property string                query_string
 * @property boolean               hard
 * @property int                   statut_id
 * @property int                   created_by
 * @property int                   updated_by
 *
 * @property Campagne[]|Collection campagnes
 *
 * @method static Builder|static published()
 */
class Redirection extends Model
{
    use IsUserTracked;

    protected $attributes = [
        'statut_id'    => Statut::PUBLIE,
        'query_string' => ''
    ];

    protected $casts = [
        'hard' => 'boolean',
    ];

    public function campagnes()
    {
        return $this->belongsToMany(Campagne::class, 'campagne_redirections');
    }

    public function scopePublished(Builder $query)
    {
        return $query->where('statut_id', '=', 1);
    }

    public function setPathChange(Page $page)
    {
        $this->setUser();
        $this->source = $page->getOriginal('pathname');
        $this->cible = $page->pathname;
        $this->hard = true;

        return $this;
    }

    public function setStatusChange(Page $page)
    {
        $this->setUser();
        $this->source = $page->pathname;
        $cible = $page->dossier ? $page->dossier->full_pathname : '/';
        if ($page->is_index) {
            $cible = $page->dossier->parent ? $page->dossier->parent->full_pathname : '/';
        }
        $this->cible = $cible;
        $this->hard = false;
        if ((int)$page->statut_id === Statut::ARCHIVE) {
            $this->hard = true;
        }

        return $this;
    }

    protected function setUser()
    {
        $id = Auth::id() ?: 1;
        if (!$this->exists) {
            $this->created_by = $id;
        }
        $this->updated_by = $id;
    }

    public function bindToSystem()
    {
        $this->campagnes()
            ->attach(Campagne::SYSTEM, ['created_by' => Auth::id(), 'updated_by' => Auth::id()]);

        return $this;
    }

    public function getParentsAttribute()
    {
        // Une redirection parente est une redirection qui cible l'url source de la redirection
        return $this->newQuery()
            ->where('cible', '=', $this->source)
            ->where('statut_id', '=', Statut::PUBLIE)
            ->get();
    }
}
