<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 27/08/2020
 * Time: 11:39
 */

namespace Bloom\CMS\Core\Http\Indexes;

use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Section
 *
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property string|int                 id
 * @property Page                       $page
 * @property int                        $rang
 * @property string                     $type
 * @property string                     $titre
 * @property int                        page_id
 * @property SectionLien|SectionDossier info
 */
class Section extends Model
{
    use IsContenu;

    public function info()
    {
        switch ($this->type) {
            case 'lien':
                return $this->hasOne(SectionLien::class);
            case 'liste':
            default:
                return $this->hasOne(SectionDossier::class);
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope(
            function (Builder $query) {
                return $query->orderBy('rang');
            }
        );
    }
}
